<div class="min-h-[calc(100vh-152px)]">
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Categorias / produtos cadastrados - <a href="painel.php?exe=produtos/create_category">Cadastrar categoria</a></h2>

    <?php
    $empty = filter_input(INPUT_GET, 'empty', FILTER_VALIDATE_BOOLEAN);
    if ($empty):
        WSErro("Ops: Você tentou editar uma categoria que não existe no sistema!", WS_INFOR);
    endif;

    $action = filter_input(INPUT_GET, 'action', FILTER_DEFAULT);
    if ($action):
        require('_models/Categorias.class.php');

        $postAction = filter_input(INPUT_GET, 'categoriaid', FILTER_VALIDATE_INT);
        $postUpdate = new Categorias;

        require('_models/Produtos.class.php');

        $postActionProduto = filter_input(INPUT_GET, 'produtoid', FILTER_VALIDATE_INT);
        $postUpdateProduto = new Produtos;

        switch ($action):
            case 'delete':
                $produtos = new Read;
                $produtos->ExeRead(DB_PRODUTOS, " WHERE id_categoria = $postAction");
                $qtdProduto = $produtos->getRowCount();

                if ($qtdProduto >= 1):
                    WSErro("Não é possível apagar esta categoria pois ela possui itens, é necessário apagar os itens primeiro!", WS_ERROR);
                else:
                    $postUpdate->ExeDelete($postAction);
                    WSErro("Categoria deletada com sucesso!", WS_ACCEPT);
                endif;
                break;

            case 'deleteProduto':
                $postUpdateProduto->ExeDelete($postActionProduto);
                WSErro($postUpdateProduto->getError()[0], $postUpdateProduto->getError()[1]);
                break;

            default:
                WSErro("Ação não foi identifica pelo sistema, favor utilize os botões!", WS_ALERT);
        endswitch;
    endif;

    $checkCreate = filter_input(INPUT_GET, 'createCategory', FILTER_VALIDATE_BOOLEAN);
    if ($checkCreate && empty($cadastra)) :
        WSErro("A categoria foi criada com sucesso!", WS_ACCEPT);
    endif;
    ?>

    <br />
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">

            <section class="grid grid-cols-1 gap-y-3 divide-y">
                <?php
                $categorias = new Read;
                $categorias->ExeRead(DB_CATEGORIAS, " ORDER BY nome ASC");
                foreach ($categorias->getResult() as $categoria):
                    extract($categoria);

                    $qtdProdutos = new Read;
                    $qtdProdutos->ExeRead(DB_PRODUTOS, " WHERE id_categoria = {$id_categoria}");
                    $qtdProduto = $qtdProdutos->getRowCount();
                    ?>
                    <details class="group py-1 text-lg">
                        <summary
                            class="flex cursor-pointer flex-row items-center justify-between py-1 font-semibold text-gray-800 marker:[font-size:0px]">
                            <?= $nome; ?> - (<?= $qtdProduto; ?> item(ns) cadastrado(s))
                            <br />
                            <p class="text-center"><a
                                    href="painel.php?exe=produtos/create_product&categoriaid=<?= $id_categoria; ?>">Cadastrar produto</a>
                                    | <a href="painel.php?exe=produtos/update_category&categoriaid=<?= $id_categoria; ?>">Editar</a>
                                | <a href="painel.php?exe=produtos/new_index&categoriaid=<?= $id_categoria; ?>&action=delete"
                                    onclick="return confirm('Tem certeza de que quer deletar este item?');">Excluir</a>
                            </p>
                            <svg class="h-6 w-6 rotate-0 transform text-gray-400 group-open:rotate-180"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
                                stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </summary>
                        <p class="text-gray-500">
                        <div class="table-responsive">
                            <table class="table-hover">
                                <thead>
                                    <tr>
                                        <th>Nome</th>
                                        <th>Categoria</th>
                                        <th>Valor</th>
                                        <th>Estoque</th>
                                        <th class="text-center">Ação</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $produtos = new Read;
                                    $produtos->ExeRead(DB_PRODUTOS, " WHERE id_categoria = {$id_categoria} ORDER BY id_categoria ASC");
                                    foreach ($produtos->getResult() as $produto):
                                        extract($produto);

                                        $vendas = new Read;
                                        $vendas->FullRead("SELECT SUM(qtd) AS qt FROM " . DB_CARRINHO . " WHERE cod = {$cod}");
                                        $qt = $vendas->getResult()[0]["qt"];

                                        $entradas = new Read;
                                        $entradas->FullRead("SELECT SUM(entry_qt) AS qt FROM " . DB_ENTRADAS . " WHERE entry_pdt = {$cod}");

                                        if ($entradas->getResult()):
                                            $entrada = $entradas->getResult()[0]["qt"];
                                            $final = $entrada + ($estoque_atual - $qt);

                                            if ($final <= $estoque_minimo):
                                                $cor = "#FFF7D4";
                                            else:
                                                $cor = "white";
                                            endif;
                                        else:

                                            if ($final <= $estoque_minimo):
                                                $cor = "#FFF7D4";
                                            else:
                                                $cor = "white";
                                            endif;
                                            $final = ($estoque_atual - $qt);
                                        endif;
                                        ?>
                                        <tr style="background-color: <?= $cor; ?> !important;">
                                            <td class="whitespace-nowrap"><?= $nome; ?></td>
                                            <td>
                                                <?php
                                                $categorias = new Read;
                                                $categorias->FullRead("SELECT * FROM " . DB_CATEGORIAS . " WHERE id_categoria = {$id_categoria}");
                                                $cat = $categorias->getResult()[0]['nome'];
                                                echo $cat;
                                                ?>
                                            </td>
                                            <td><?= number_format($preco, 2, ',', '.'); ?></td>
                                            <td><?= $final; ?></td>
                                            <td class="text-center"><a
                                                    href="painel.php?exe=produtos/entrada&produtoid=<?= $cod; ?>">Lançar
                                                    estoque</a> |
                                                <a href="painel.php?exe=produtos/update&produtoid=<?= $cod; ?>">Editar</a> | <a
                                                    href="painel.php?exe=produtos/new_index&produtoid=<?= $cod; ?>&action=deleteProduto"
                                                    onclick="return confirm('Tem certeza de que quer deletar este item?');">Excluir</a>
                                            </td>
                                        </tr>
                                        <?php
                                    endforeach;
                                    ?>
                                </tbody>
                            </table>
                        </div>
                        </p>
                    </details>
                    <?php
                endforeach;
                ?>
            </section>
        </div>
    </div>
</div>