<?php
date_default_timezone_set('America/Fortaleza');
require('../../_app/Config.inc.php');

$dt_inicial = date('Y-m-d');
$h_inicial = "17:00:00";
$dt1 = $dt_inicial . " " . $h_inicial;

$dt_final = date('Y-m-d');
$h_final = "23:59:00";
$dt2 = $dt_final . " " . $h_final;
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "https://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html lang="pt-br" xmlns="https://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Relatório vendas diário</title>

    <style type="text/css">
        body,
        td,
        th {
            font-family: Consolas;
            font-size: 14px;
        }

        .titulo {
            font-size: 16px;
        }

        hr {
            color: #f2f2f2;
        }
    </style>

    <script type="text/javascript">
        window.onload = function() {
            window.print();
        }
    </script>

</head>

<body>
    <table width="340" border="0" align="center" class="inputs">
        <tr>
            <td align="center"><strong><span class="titulo">Relatório de vendas</span></strong></td>
        </tr>
        <tr>
            <td align="center"> <br /> DATA - <?= date('d/m/Y', strtotime($dt1)); ?> - <?= $h_inicial; ?> | <?= date('d/m/Y', strtotime($dt2)); ?> - <?= $h_final; ?></td>
        </tr>
        <tr>
            <td>
                <hr />
            </td>
        </tr>
        </tr>
    </table>
    <table width="340" align="center">
        <tr>
            <td><strong>DATA</strong></td>
            <td align="center"><strong>PRODUTO</strong></td>
            <td align="center"><strong>QTD</strong></td>
            <td align="center"><strong>PREÇO</strong></td>
            <td align="center"><strong>TOTAL</strong></td>
        </tr>
        <?php
        $somatorio = 0;
        $relatorios = new Read;
        $relatorios->FullRead("SELECT *, SUM(qtd) AS QTD, preco AS PRECO, nome AS NOME, info as INFO FROM " . DB_CARRINHO . " WHERE info BETWEEN '{$dt1}' AND '{$dt2}' GROUP BY nome");

        foreach ($relatorios->getResult() as $relatorio) :
            extract($relatorio);

            $somatorio += $PRECO * $QTD;
        ?>
            <tr class="fontcomanda">
                <td align="left">
                    <?= date('d/m/Y', strtotime($INFO)); ?>
                </td>
                <td align="left">
                    <?= $NOME; ?>
                </td>
                <td align="center">
                    <?= $QTD; ?>
                </td>
                <td align="right">
                    <?= number_format($PRECO, 2, ',', '.'); ?>
                </td>
                <td align="right">
                    <?= number_format($PRECO * $QTD, 2, ',', '.'); ?>
                </td>
            </tr>
        <?php
        endforeach;
        ?>
        <tr class="fontcomanda">
            <td align="left">
                <b>TOTAL VENDAS</b>
            </td>
            <td align="left">
                <b>R$ <?= number_format($somatorio, 2, ',', '.'); ?></b>
            </td>
        </tr>

        <tr class="fontcomanda">
            <td align="left">
                <b>TOTAL COMISSÃO</b>
            </td>
            <td align="left">
                <?php
                $porcentagem = new Read;
                $porcentagem->FullRead("SELECT *, SUM(preco) AS TOTAL FROM " . DB_CARRINHO . " WHERE porcento = 0 AND info BETWEEN '{$dt1}' AND '{$dt2}'" );
                $por = $porcentagem->getResult()[0]['TOTAL'];

                $fpor = ($por * 10) / 100;
                ?>
                <b>R$ <?= number_format(((($somatorio * 10) / 100) - $fpor), 2, ',', '.'); ?></b>
            </td>
        </tr>
    </table>
    <br />
    <br />
</body>

</html>