<div class="min-h-[calc(100vh-152px)]">
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);

    if (isset($post) && $post['SendPostForm']):
        unset($post['SendPostForm']);

        require('_models/Alimentos.php');
        $cadastra = new Alimentos;
        $cadastra->ExeCreate($post);

        if ($cadastra->getResult()):
            header('Location: painel.php?exe=estoque/index_item&create=true&produtoid=' . $cadastra->getResult());
        else:
            WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
        endif;
    endif;
    ?>
    <br />
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Cadastrar alimento</h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <div class="grid grid-cols-3 gap-5">
                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Nome do item</label>
                        <input type="text" class="form-input" name="estoque_nome" placeholder="Informe o nome do item" value="<?php if (isset($post['estoque_nome']))
                            echo $post['estoque_nome']; ?>" autofocus>
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Quantidade</label>
                        <input type="text" class="form-input" name="estoque_qtd" placeholder="Informe a quantidade" value="<?php if (isset($post['estoque_qtd']))
                            echo $post['estoque_qtd']; ?>">
                    </div>

                    <div>
                        <label
                            class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Unidade</label>
                        <select name="estoque_und" class="form-select">
                            <option value="">Selecione</option>
                            <option value="UNIDADE" <?php if (isset($post['estoque_und']) && $post['estoque_und'] == 'UNIDADE')
                                echo 'selected="selected"'; ?>>Unidade</option>
                            <option value="KILO" <?php if (isset($post['estoque_und']) && $post['estoque_und'] == 'KILO')
                                echo 'selected="selected"'; ?>>Kilo</option>
                        </select>
                    </div>
                </div>
                <div>
                    <br />
                    <input type="submit"
                        class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700"
                        value="Cadastrar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>