<?php
ob_start();
session_start();
require('./_app/Config.inc.php');

$pagamento = 1;

if ($pagamento == 0) :
?>
    <!DOCTYPE html>
    <html x-data="main" class :class="[$store.app.mode]">

    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="description" content="Edgar Magalhães" />
        <meta name="author" content="Edgar Magalhães" />

        <title><?= SYSNAME; ?></title>

        <link rel="shortcut icon" href="assets/images/favicon.ico" />

        <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    </head>

    <body x-data="main" class="collapse-menu overflow-x-hidden bg-lightwhite font-public text-base font-normal text-slate-600 antialiased dark:bg-darkblue dark:text-indigo-300" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.fullscreen ? '' : '']">

        <div>
            <div class="container">
                <div class="min-h-screen flex items-center justify-center text-[15px]">
                    <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10 w-full max-w-md my-10 mx-4">
                        <?php
                        WSErro('<b>Entre em contato por whatsapp (85) 987 548 429</b>!', WS_ERROR);
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <script src="assets/js/alpine-collaspe.min.js"></script>
        <script src="assets/js/alpine-persist.min.js"></script>
        <script src="assets/js/alpine.min.js" defer></script>

        <script src="assets/js/custom.js"></script>
    </body>

    </html>
<?php
else :
?>
    <!DOCTYPE html>
    <html x-data="main" class="dark">

    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <meta name="description" content="Edgar Magalhães" />
        <meta name="author" content="Edgar Magalhães" />

        <title><?= SYSNAME; ?></title>

        <link rel="shortcut icon" href="assets/images/favicon.ico" />

        <link rel="stylesheet" type="text/css" media="screen" href="assets/css/style.css" />
    </head>

    <body x-data="main" class="collapse-menu overflow-x-hidden bg-lightwhite font-public text-base font-normal text-slate-600 antialiased dark:bg-darkblue dark:text-indigo-300" :class="[ $store.app.sidebar ? 'toggle-sidebar' : '', $store.app.fullscreen ? '' : '']">

        <div>
            <div class="container">
                <div class="min-h-screen flex items-center justify-center text-[15px]">
                    <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10 w-full max-w-md my-10 mx-4">
                        <?php
                        $login = new Login(1);

                        if ($login->CheckLogin()) :
                            header('Location: painel.php');
                        endif;

                        $dataLogin = filter_input_array(INPUT_POST, FILTER_DEFAULT);
                        if (!empty($dataLogin['AdminLogin'])) :

                            $login->ExeLogin($dataLogin);
                            if (!$login->getResult()) :
                                WSErro($login->getError()[0], $login->getError()[1]);
                            else :
                                header('Location: painel.php');
                            endif;
                        endif;

                        $get = filter_input(INPUT_GET, 'exe', FILTER_DEFAULT);
                        if (!empty($get)) :
                            if ($get == 'restrito') :
                                WSErro('<b>Ops:</b> Acesso negado. Favor efetue login para acessar o painel!', WS_ALERT);
                            elseif ($get == 'logoff') :
                                WSErro('<b>Sucesso ao deslogar:</b> Sua sessão foi finalizada. Volte sempre!', WS_ACCEPT);
                            endif;
                        endif;
                        ?>
                        <br />
                        <h4 class="mb-2 text-[22px] text-center font-medium text-slate-600 dark:text-indigo-300">Bem-vindo novamente ao <?= SYSNAME; ?></h4>
                        <form name="AdminLoginForm" action="" method="post">
                            <div class="mb-4">
                                <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Usuário</label>
                                <input type="text" name="user" class="form-input" placeholder="informe o seu usuário" autofocus>
                            </div>
                            <div class="mb-4">
                                <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Senha</label>
                                <input type="password" name="pass" class="form-input" placeholder="********">
                            </div>
                            <input type="submit" name="AdminLogin" value="Entrar" class="btn w-full mb-4 justify-center border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 hover:bg-indigo-700" />
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <script src="assets/js/alpine-collaspe.min.js"></script>
        <script src="assets/js/alpine-persist.min.js"></script>
        <script src="assets/js/alpine.min.js" defer></script>

        <script src="assets/js/custom.js"></script>
    </body>

    </html>
<?php
endif;
?>


<?php
ob_end_flush();
