<?php
header("Refresh: 3");

require __DIR__ . '/vendor/autoload.php';

use Mike42\Escpos\Printer;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
use Mike42\Escpos\PrintConnectors\NetworkPrintConnector;

// ==== CONECTOR (mesma lógica do teste) ====
$connector = new WindowsPrintConnector("Tanca TP-620"); // ou NetworkPrintConnector

$pdo = new PDO("mysql:host=edgarmagalhaes.com;dbname=edgarmag_alespetush;charset=utf8mb4", "edgarmag_alespetush", "Alice@2016(!)", [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
]);

// Ex.: ecm_cart: pegue os itens não impressos (ajuste sua query)
$itens = $pdo->query("SELECT id, comanda, nome, qtd, preco, mesa_id, id_garcom, token, data, time
                      FROM ecm_cart
                      WHERE impresso = 0 AND destino = 1
                      GROUP BY token")->fetchAll();

if (!$itens) {
    echo "Nada a imprimir.\n";
    exit;
}

// Agrupa por comanda
$porComanda = [];
foreach ($itens as $r) {
    $porComanda[$r['token']][] = $r;
}

$printer = new Printer($connector);
try {
    $printer->selectCharacterTable(Printer::CHARSET_PC860_PORTUGUESE);
} catch (Throwable $e) {
}

foreach ($porComanda as $comanda => $linhas) {
    // Cabeçalho
    $printer->setJustification(Printer::JUSTIFY_CENTER);
    $printer->setEmphasis(true);
    $printer->text("PEDIDO\n");
    $printer->setEmphasis(false);
    $printer->text(str_repeat("-", 42) . "\n");

    // Info
    $h = $linhas[0];
    $printer->setJustification(Printer::JUSTIFY_LEFT);
    $printer->setEmphasis(true);
    $printer->text("MESA #{$h['mesa_id']}\n");
    $printer->setEmphasis(false);
    if (!empty($h['data']))
        $printer->text("Data: {$h['data']} {$h['time']}\n");
    $printer->text(str_repeat("-", 42) . "\n");

    // Itens
    $total = 0.0;
    foreach ($linhas as $it) {
        $q = (float) $it['qtd'];
        $p = (float) str_replace(",", ".", (string) $it['preco']);
        $sub = $q * $p;
        $total += $sub;
        $qfmt = rtrim(rtrim(number_format($q, 2, ',', '.'), '0'), ',');
        $left = "{$qfmt}x {$it['nome']}";
        $right = "";
        $spaces = max(1, 42 - mb_strwidth($left) - mb_strwidth($right));
        $printer->text($left . str_repeat(' ', $spaces) . $right . "\n");
    }

    $printer->text(str_repeat("-", 42) . "\n");
    $printer->setEmphasis(true);
    $printer->setEmphasis(false);

    try {
        $printer->cut();
    } catch (Throwable $e) {
    }

    // Marca como impresso
    $ids = array_column($linhas, 'id');
    $in = implode(',', array_fill(0, count($ids), '?'));
    $st = $pdo->prepare("UPDATE ecm_cart SET impresso = 1 WHERE id IN ($in)");
    $st->execute($ids);
}

$printer->close();
echo "Comandas impressas.\n";
