<?php
require('../../_app/Config.inc.php');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>Cardápio Digital - Espetinho Bate-Papo</title>
    <meta content="" name="Desenvolvido por 123Devs">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,300i,400,400i,600,600i,700,700i|Satisfy|Comic+Neue:300,300i,400,400i,700,700i" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="assets/vendor/animate.css/animate.min.css" rel="stylesheet">
    <link href="assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
    <link href="assets/vendor/boxicons/css/boxicons.min.css" rel="stylesheet">
    <link href="assets/vendor/glightbox/css/glightbox.min.css" rel="stylesheet">
    <link href="assets/vendor/swiper/swiper-bundle.min.css" rel="stylesheet">

    <!-- Template Main CSS File -->
    <link href="assets/css/style.css" rel="stylesheet">
</head>

<body>
    <main id="main">
        <!-- ======= Menu Section ======= -->
        <section id="menu" class="menu">
            <div class="container">

                <div class="section-title">
                    <h2>Nosso <span>Cardápio</span></h2>
                    <br />
                    <b>Escolha uma categoria</b>
                </div>

                <div class="row">
                    <div class="col-lg-12 d-flex justify-content-center">
                        <ul id="menu-flters">
                            <li data-filter="*" class="filter-active">MOSTRAR TODOS</li>
                            <?php
                            $categorias = new Read;
                            $categorias->ExeRead(DB_CATEGORIAS, " WHERE nome <> 'OUTROS' AND nome <> 'TESTE' ORDER BY nome ASC");
                            foreach ($categorias->getResult() as $categoria) :
                                extract($categoria);
                            ?>
                                <li data-filter=".filter-<?= $id_categoria; ?>"><?= $nome; ?></li>
                            <?php
                            endforeach;
                            ?>
                        </ul>
                    </div>
                </div>

                <div class="row menu-container">
                    <?php
                    $produtos = new Read;
                    $produtos->ExeRead(DB_PRODUTOS, "ORDER BY nome ASC");
                    foreach ($produtos->getResult() as $produto) :
                        extract($produto);
                    ?>
                        <div class="col-lg-6 menu-item filter-<?= $id_categoria; ?>">
                            <div class="menu-content">
                                <a href="#"><?= $nome; ?></a><span>R$ <?= number_format($preco, 2, ',', '.'); ?></span>
                            </div>
                        </div>
                    <?php
                    endforeach;
                    ?>
                </div>

            </div>
        </section><!-- End Menu Section -->
    </main><!-- End #main -->

    <!-- ======= Footer ======= -->
    <footer id="footer">
        <div class="container">
            <h3>Espetinho Bate-Papo</h3>
            <p>Avenida 20 de janeiro, 253</p>
            <div class="social-links">
                <a href="https://www.instagram.com/espetinho_bate_papo/" class="instagram" target="_blank"><i class="bx bxl-instagram"></i></a>
            </div>
            <div class="copyright">
                &copy; Desenvolvido por <strong><span><a href="https://123devs.com.br" target="_blank">123Devs</a></span></strong>.
            </div>
        </div>
    </footer><!-- End Footer -->

    <!-- Vendor JS Files -->
    <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="assets/vendor/glightbox/js/glightbox.min.js"></script>
    <script src="assets/vendor/isotope-layout/isotope.pkgd.min.js"></script>
    <script src="assets/vendor/swiper/swiper-bundle.min.js"></script>
    <script src="assets/vendor/php-email-form/validate.js"></script>

    <!-- Template Main JS File -->
    <script src="assets/js/main.js"></script>

</body>

</html>