<div class="min-h-[calc(100vh-152px)]">
    <?php
    $delete = filter_input(INPUT_GET, 'delete', FILTER_VALIDATE_INT);
    if ($delete) :
        require('_models/AdminUser.class.php');
        $delUser = new AdminUser;
        $delUser->ExeDelete($delete);
        WSErro($delUser->getError()[0], $delUser->getError()[1]);
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Usuários cadastrados</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <div class="table-responsive">
                <table class="table-hover">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Usuário</th>
                            <th>Nível</th>
                            <th class="text-center">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $read = new Read;
                        $read->ExeRead(DB_USERS, "ORDER BY user_level DESC, user_name ASC");
                        foreach ($read->getResult() as $user) :
                            extract($user);
                            $user_lastupdate = ($user_lastupdate ? date('d/m/Y H:i', strtotime($user_lastupdate)) . ' hs' : '-');
                            $nivel = ['', 'Garçom/Cozinha', 'Gerente', 'Admin'];
                        ?>
                            <tr>
                                <td class="whitespace-nowrap"><?= $user_name . ' ' . $user_lastname; ?></td>
                                <td><?= $user_user; ?></td>
                                <td><?= $nivel[$user_level]; ?></td>
                                <td class="text-center"><a href="painel.php?exe=users/update&userid=<?= $user_id; ?>">Editar</a> | <a href="painel.php?exe=users/users&delete=<?= $user_id; ?>">Deletar</a></td>
                            </tr>
                        <?php
                        endforeach;
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>