<div class="min-h-[calc(100vh-152px)]">
    <?php
    $post = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $postid = filter_input(INPUT_GET, 'caixa_id', FILTER_VALIDATE_INT);

    if (isset($post) && $post['SendPostForm']) :
        unset($post['SendPostForm']);

        require('_models/Caixa.class.php');
        $cadastra = new Caixa;
        $cadastra->ExeUpdate($postid, $post);

        WSErro($cadastra->getError()[0], $cadastra->getError()[1]);
    endif;
    ?>
    <h2 class="mb-6 text-lg font-medium text-slate-600 dark:text-white">Caixa</h2>
    <div class="grid grid-cols-1 gap-6">
        <div class="rounded-lg bg-white p-6 shadow-3xl dark:bg-lightblue dark:shadow-black/10">
            <h5 class="mb-6 text-base font-medium text-slate-600 dark:text-indigo-300">Fechar caixa</h5>
            <form name="PostForm" action="" method="post" enctype="multipart/form-data">
                <div class="grid grid-cols-3 gap-5">
                    <input type="hidden" name="caixa_situacao" value="0" />
                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe o valor em dinheiro</label>
                        <input type="text" class="form-input" name="caixa_dinheiro" placeholder="Informe o valor em dinheiro" value="<?php if (isset($post['caixa_dinheiro'])) echo $post['caixa_dinheiro']; ?>" autofocus>
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe o valor em cartão de crédito</label>
                        <input type="text" class="form-input" name="caixa_credito" placeholder="Informe o valor em cartão de crédito" value="<?php if (isset($post['caixa_credito'])) echo $post['caixa_credito']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe o valor em cartão de débito</label>
                        <input type="text" class="form-input" name="caixa_debito" placeholder="Informe o valor em cartão de débito" value="<?php if (isset($post['caixa_debito'])) echo $post['caixa_debito']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe o valor em contas assinadas</label>
                        <input type="text" class="form-input" name="caixa_contaassinada" placeholder="Informe o valor em contas assinadas" value="<?php if (isset($post['caixa_contaassinada'])) echo $post['caixa_contaassinada']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe o valor em pix</label>
                        <input type="text" class="form-input" name="caixa_pix" placeholder="Informe o valor em pix" value="<?php if (isset($post['caixa_pix'])) echo $post['caixa_pix']; ?>">
                    </div>

                    <div>
                        <label class="text-xs uppercase text-gray-500 dark:text-indigo-300 font-medium mb-2 inline-block">Informe o valor o pagamento online</label>
                        <input type="text" class="form-input" name="caixa_pgonline" placeholder="Informe o valor em pagamentos online" value="<?php if (isset($post['caixa_pgonline'])) echo $post['caixa_pgonline']; ?>">
                    </div>
                </div>
                <div>
                    <br />
                    <input type="submit" class="btn border-indigo-600 bg-indigo-600 text-white hover:border-indigo-700 dark:disabled:bg-white/10 dark:disabled:border-white/10 disabled:bg-gray-300 disabled:border-gray-300 hover:bg-indigo-700" value="Atualizar" name="SendPostForm" />
                </div>
            </form>
        </div>
    </div>
</div>